/* eslint-disable import/no-extraneous-dependencies */
import React, { useEffect, useState } from "react";
import { useNavigate } from "react-router-dom";

import { DeviceFunctionalAspectType, useDevicesByAspectTypesShortLazyQuery, useGetGuisQuery, useSolidConfigLazyQuery, useSystemStatusQuery } from "@generated/graphql";
import { useStore } from "@core/store";
import { parseJSON } from "utils";
import { currentVersion, SolidConfigRoot } from "@core/store/actions";

import SystemStatus from "components/SystemStatus";
import GuiList from "components/GuiList";
import PageWrapper from "components/PageWrapper";

import "./style.css";

enum SolidStartRoutes {
  Main = "/main",
  AvatarActivation = "/view/AvatarActivation",
  CreateCamera = "/view/camera/add",
  Start = "/view/start"
}

const SelectGUIPage = () => {
  const navigate = useNavigate();
  const { store: { session: { info } } } = useStore();
  const [getSolidConfig, { data: solidConfigData, loading: solidConfigLoading }] = useSolidConfigLazyQuery();
  const { data: guisData, loading: guisLoading, error: guisError } = useGetGuisQuery();
  const { data: statusData, loading: statusLoading, error: statusError } = useSystemStatusQuery({ fetchPolicy: "no-cache" });
  const [getAvatarsAndCameras, { data: devicesData, loading: deviceLoading }] = useDevicesByAspectTypesShortLazyQuery({
    variables: { types: [{ type: DeviceFunctionalAspectType.Media }, { type: DeviceFunctionalAspectType.Avatar }] }
  });
  const [loadingSolidDevice, setLoadingSolidDevice] = useState(false);

  const setGui = (url: string, isHash: boolean = true) => {
    if (isHash) {
      navigate(url);
    } else {
      window.location.href = url;
    }
  };

  // TODO: correct auto select GUI for electron
  /*
  useEffect(() => {
    if (isElectron()
        && guisData?.guis.length === 1
        && guisData?.guis.some((gui: Gui) => gui.id === "SOLID")
        && statusData?.systemStatus.reasons?.length === 0
    ) {
      setGui("/main");
    }
  }, [guisData, statusData]);
  */

  useEffect(() => {
    if (guisData?.guis.some(gui => gui.id === "SOLID")) {
      getAvatarsAndCameras();
      setLoadingSolidDevice(deviceLoading);
    }
  }, [guisData, deviceLoading]);

  useEffect(() => {
    if (!info) {
      return;
    }
    getSolidConfig({ variables: { userId: info.user.id } });
  }, [info]);

  const setGuiWithStartSolidNavigation = (url: string, guiId?: string, isHash: boolean = false) => {
    const includeCameras = devicesData?.devicesByAspectTypes.some(device => device.aspects.some(aspect => aspect.type === DeviceFunctionalAspectType.Media));
    const includeAvatars = devicesData?.devicesByAspectTypes.some(device => device.aspects.some(aspect => aspect.type === DeviceFunctionalAspectType.Avatar));

    if (guiId === "SOLID") {
      if (!includeAvatars) {
        isHash = true;
        url = SolidStartRoutes.AvatarActivation;
      } else
      if (!includeCameras) {
        isHash = true;
        url = SolidStartRoutes.CreateCamera;
      }

      if (url.includes("/main")) {
        let toDefaultURL = true;
        if (solidConfigData && solidConfigData.solidConfig) {
          const confRoot = parseJSON<SolidConfigRoot>(solidConfigData.solidConfig);
          if (confRoot) {
            const views = confRoot[currentVersion]?.views;
            if (views && views.length > 0) {
              toDefaultURL = false;
              isHash = true;
              url = `/view/${views[0].id}`;
            }
          }
        }

        if (toDefaultURL) {
          isHash = true;
          url = SolidStartRoutes.Start;
        }
      }
    }

    setGui(url, isHash);
  };

  return (
    <PageWrapper>
      <div className="main-container">
        <div className="system-status-container">
          <SystemStatus data={statusData} loading={statusLoading} error={statusError} />
        </div>
        <div className="line"/>
        <div className="guis-list-container">
          <GuiList guiList={guisData?.guis} error={guisError} loading={guisLoading || loadingSolidDevice || solidConfigLoading} setGui={setGuiWithStartSolidNavigation} />
        </div>
      </div>
    </PageWrapper>
  );
};

export default SelectGUIPage;
