/* eslint-disable import/no-extraneous-dependencies */
import React, { useEffect } from "react";
import { Image } from "semantic-ui-react";
import { useNavigate } from "react-router-dom";
import PageWrapper from "components/PageWrapper";
import PasswordExpired from "components/PasswordExpired";
import { Activity, ActivityItem, ActivityItemProps } from "components/Activity";
import { origin } from "core/api";
import { useStore } from "@core/store";
import { FontAwesomeIcon } from "@fortawesome/react-fontawesome";
import { useUserInfoQuery } from "@generated/graphql";
import useLogout from "@core/useLogout";

import "./style.css";

const PasswordExpiredPage = () => {
  const { loading: isPending, error, data: info } = useUserInfoQuery();
  const navigate = useNavigate();
  const { store: { branding } } = useStore();
  const { logout } = useLogout();

  const items: React.ReactElement<ActivityItemProps, typeof ActivityItem>[] = [
    <ActivityItem key="Logout" name="" holdSideBar icon={<FontAwesomeIcon icon="sign-out-alt" onClick={() => logout()}/>} />
  ];

  useEffect(() => {
    if (!isPending && !error && info) {
      navigate("/");
    }
  }, [isPending, info, error]);

  return (
    <div className="page-wrapper">
      <div className="wrapper-logout">
        <Activity isSideBarVisible={false}>
          {items}
        </Activity>
      </div>
      <PageWrapper>
        <div className="left-side-expired">
          <Image src={`${origin}${branding?.LOGIN_BACKGROUND_PATH ?? ""}`} fluid/>
        </div>
        <div className="right-side-expired">
          <PasswordExpired/>
        </div>
      </PageWrapper>
    </div>
  );
};

export default PasswordExpiredPage;
