import React from "react";
import { Image } from "semantic-ui-react";
import PageWrapper from "components/PageWrapper";
import Eula from "components/Eula";
import {origin} from "core/api";
import { useStore } from "@core/store";

import "./style.css";

const EulaPage = () => {
  const { store: { branding } } = useStore();

  return (
    <PageWrapper showLanguageSelector>
      <div className="left-side">
        <Image src={`${origin}${branding?.LOGIN_BACKGROUND_PATH ?? ""}`} fluid/>
      </div>
      <div className="eula-right-side">
        <Eula/>
      </div>
    </PageWrapper>
  );
};

export default EulaPage;
