import React from "react";
import { Image } from "semantic-ui-react";
import PageWrapper from "components/PageWrapper";
import ChangePasswordWithSecret from "components/ChangePasswordWithSecret";
import {origin} from "core/api";
import { useStore } from "@core/store";

import "./style.css";

type ChangePasswordPageProps = {
  mode: "email" | "password"
};

const ChangePasswordPage = (props: ChangePasswordPageProps) => {
  const { store: { branding } } = useStore();

  return (
    <PageWrapper>
      <div className="left-side-confirm-email">
        <Image src={`${origin}${branding?.LOGIN_BACKGROUND_PATH ?? ""}`} fluid/>
      </div>
      <div className="right-side-confirm-email">
        <ChangePasswordWithSecret mode={props.mode}/>
      </div>
    </PageWrapper>
  );
};

export default ChangePasswordPage;
