import "@core/app";
import { API } from "@solid/libs/api";
import Sentry from "@sentry/react";

async function setSentry() {
  try {
    if (process.env.VERSION !== "latest") {
      const api = new API();
      const response = await api.getParameters();
      const SENTRY_ENABLED = response.list.SENTRY_ENABLED ? response.list.SENTRY_ENABLED : "no";
      const SENTRY_DSN = response.list.SENTRY_DSN;
      if (SENTRY_ENABLED === "yes" && SENTRY_DSN) {
        const SENTRY_TRACES_SAMPLE_RATE = response.list.SENTRY_TRACES_SAMPLE_RATE ?? 1.0;
        const SENTRY_ERROR_SAMPLE_RATE = response.list.SENTRY_ERROR_SAMPLE_RATE ?? 1.0;
        Sentry.init({
          dsn: SENTRY_DSN,
          integrations: [new Sentry.BrowserTracing()],
          sampleRate: SENTRY_ERROR_SAMPLE_RATE,
          tracesSampleRate: SENTRY_TRACES_SAMPLE_RATE,
          release: `solid-react@${process.env.VERSION}`
        });
      }
    }
  } catch (e: any) {
    console.error(e.message);
  }
}

setSentry();
