import * as os from "os";

export enum Platform {
  Windows = "windows",
  Darwin = "darwin",
  Unsupported = "unsupported"
}

export function getPlatform(): Platform {
  if (os.arch() === "x64") {
    switch (os.platform()) {
      case "win32": return Platform.Windows;
      case "darwin": return Platform.Darwin;
    }
  }
  return Platform.Unsupported;
}
