import { useCallback } from "react";
import { useStore } from "@core/store";
import { useUserInfoLazyQuery } from "@generated/graphql";

export type LoginDoneResult = {
  loginDone: () => void;
};

export function useLoginDone(): LoginDoneResult {
  const { setStore } = useStore();
  const [getUserInfo] = useUserInfoLazyQuery({fetchPolicy: "network-only"});

  const loginDone = useCallback(async () => {
    console.log("loginDone");
    const { data } = await getUserInfo();
    if (data) {
      await setStore({ session: { isLoggedIn: true, isAdmin: data?.userInfo.user.isAdmin, info: data?.userInfo} });
    }
  }, [setStore]);

  return { loginDone };
}
