import { useMemo } from "react";
import { useStore } from "@core/store";
import { BasicAccessConfiguration, ViewId, WidgetId } from "@generated/graphql";

export type BasicConfig = {
  [x in BasicAccessConfiguration]?: boolean;
};

type BasicAccessConfig = {
  config: BasicConfig;
};

type AccessAbilityProps = {
  viewId?: ViewId;
  widgetId?: WidgetId;
};

export function useAccessability(props: AccessAbilityProps = {}): BasicAccessConfig {
  const { viewId, widgetId } = props;
  if (viewId && widgetId) {
    throw Error("To many arguments");
  }
  const { store: { session: { info } } } = useStore();

  const accessability = useMemo(() => {
    const accessConfig: BasicAccessConfig = { config: {} };
    if (info?.user.solidConfiguration) {
      const { config, widgets, views } = info?.user.solidConfiguration;
      accessConfig.config = config;

      if (viewId) {
        const currentViewConf = views.find(viewConf => viewConf.viewId === viewId);
        if (currentViewConf) {
          accessConfig.config = { ...currentViewConf.config };
        }
      }

      if (widgetId) {
        const currentWidgetConf = widgets.find(widgetConf => widgetConf.widgetId === widgetId);
        if (currentWidgetConf) {
          accessConfig.config = { ...currentWidgetConf.config };
        }
      }
    }

    return accessConfig;
  }, [info, viewId, widgetId]);

  return accessability;
}
