import { useEffect, useState } from "react";
import { makeVar, useReactiveVar } from "@apollo/client";

import { useStore } from "@core/store";
import { ObjectAction, ObjectUpdateSubscriptionHookResult, useObjectUpdateSubscription } from "@generated/graphql";

const ObjectUpdateResult = makeVar<ObjectUpdateSubscriptionHookResult>({ loading: false });
const ObjectUpdateSubscribed = makeVar<boolean>(false);

export const useObjectUpdate = (): ObjectUpdateSubscriptionHookResult => {
  const [skipSubscription, setSkipSubscription] = useState<boolean>(true);

  const objectUpdateSubscribed = useReactiveVar(ObjectUpdateSubscribed);
  const objectUpdateResult = useReactiveVar(ObjectUpdateResult);

  const { store: { session: { isLoggedIn } } } = useStore();

  const { data: subData, error: subError, loading } = useObjectUpdateSubscription({
    variables: {
      filter: { actions: [ObjectAction.Create, ObjectAction.Update, ObjectAction.Delete, ObjectAction.Status] }
    },
    skip: !isLoggedIn || skipSubscription,
    shouldResubscribe: true
  });

  useEffect(() => {
    if (!objectUpdateSubscribed && isLoggedIn && skipSubscription) {
      setSkipSubscription(false);
      ObjectUpdateSubscribed(true);
    }
  }, [objectUpdateSubscribed, isLoggedIn]);

  useEffect(() => {
    if (!subData && !subError) return;
    ObjectUpdateResult({
      data: subData,
      error: subError,
      loading
    });
  }, [subData, subError, loading]);

  return objectUpdateResult;
};
