import { useState, useEffect } from "react";
import { DisplayInfo } from "electron/screen";
import { MessageId } from "electron/types";
import type Electron from "electron";

export function useDisplays(): { displays: DisplayInfo[] } {
  const [displays, setDisplays] = useState<DisplayInfo[]>([]);

  useEffect(() => {
    if (window.ipcRenderer) {
      window.ipcRenderer.send(MessageId.GetDisplays);
    }
  }, []);

  useEffect(() => {
    if (window.ipcRenderer) {
      window.ipcRenderer.on(MessageId.GetDisplaysReply, onGetDisplaysReply);
      window.ipcRenderer.on(MessageId.DisplaysChanged, onDisplaysChanged);
      window.ipcRenderer.on(MessageId.WindowDisplayChanged, onWindowDisplayChanged);
    }

    return function cleanup() {
      if (window.ipcRenderer) {
        window.ipcRenderer.off(MessageId.GetDisplaysReply, onGetDisplaysReply);
        window.ipcRenderer.off(MessageId.DisplaysChanged, onDisplaysChanged);
        window.ipcRenderer.off(MessageId.WindowDisplayChanged, onWindowDisplayChanged);
      }
    };
  });

  function onGetDisplaysReply(event: Electron.IpcRendererEvent, displays: DisplayInfo[]): void {
    setDisplays(displays);
  }

  function onDisplaysChanged(): void {
    window.ipcRenderer.send(MessageId.GetDisplays);
  }

  function onWindowDisplayChanged(): void {
    window.ipcRenderer.send(MessageId.GetDisplays);
  }

  return { displays };
}
