import React from "react";
import {Widget} from "./Widget";
import {WidgetProps} from "components/Widgets";
import GEOMapCellStub from "components/GEOMap/GEOMapCellStub";

export class GeoMapWidget extends Widget {
  protected override createNew(): Widget {
    return new GeoMapWidget(this.id, this.name, this.title, this.module, this.icon, this.options);
  }

  override renderStub(): React.ComponentType<WidgetProps> {
    return Stub;
  }
}

const Stub = (props: WidgetProps) => {
  return <GEOMapCellStub {...props}/>;
};
