import React from "react";
import WidgetRender, { WidgetRenderProps } from "components/Widgets/WidgetRender";

type WidgetRenderWrapperProps = WidgetRenderProps;

type WidgetRenderWrapperState = {};

class WidgetRenderWrapper extends React.Component<WidgetRenderWrapperProps, WidgetRenderWrapperState> {
  constructor(props: WidgetRenderWrapperProps) {
    super(props);
    this.state = {};
  }

  override shouldComponentUpdate(nextProps: WidgetRenderWrapperProps, nextState: WidgetRenderWrapperState): boolean {
    const { module, widgetId, componentProps, selectedInConstructor } = this.props;
    return JSON.stringify(module) !== JSON.stringify(nextProps.module) ||
      widgetId !== nextProps.widgetId ||
      JSON.stringify(componentProps) !== JSON.stringify(nextProps.componentProps) ||
      selectedInConstructor !== nextProps.selectedInConstructor;
  }

  override render() {
    return (
      <WidgetRender {...this.props} />
    );
  }
}

export default WidgetRenderWrapper;
