import React from "react";
import { useDrag } from "react-dnd";
import classNames from "classnames";
import { ReactSVG } from "react-svg";
import { Widget, WidgetDragObjectType, WidgetDragObject } from "components/Widgets";

import "./style.css";

type WidgetListItemProps = {
  widget: Widget;
  disabled?: boolean;
};

const WidgetListItem = ({ widget: { id, title, icon }, disabled }: WidgetListItemProps) => {
  const [, dragRef] = useDrag<WidgetDragObject, {}, { dragging: boolean }>({
    item: { type: WidgetDragObjectType, id },
    collect: monitor => ({
      dragging: monitor.isDragging(),
    }),
    canDrag: !disabled
  });

  return (
    <div ref={dragRef} className={classNames(`WidgetList-Item WidgetListItem__${id}`, { "WidgetList-Item_disabled": disabled })}>
      <ReactSVG role="icon" src={icon} wrapper="div"/>
      <div>{title}</div>
    </div>
  );
};

export default WidgetListItem;
