import classNames from "classnames";
import React, {useRef, useState} from "react";
import {Segment} from "semantic-ui-react";
import {origin} from "@core/api";

import "./style.css";

const WatchlistFacial = () => {
  const [loading, setLoading] = useState<boolean>(true);
  const iframeRef = useRef<HTMLIFrameElement>(null!);

  const onLoad = () => {
    if (!iframeRef.current.contentWindow) {
      console.error("!iframeRef.current.contentWindow");
      return;
    }
    setLoading(false);
  };

  return (
    <Segment className={classNames("Watchlist", { loading })}>
      <iframe
        id="Watchlist__iframe"
        className="Watchlist__iframe"
        src={`${origin}/sdi/watchlist/index.html#!/facial`}
        frameBorder="0"
        title="Watchlist"
        ref={iframeRef}
        onLoad={() => onLoad()}
      />
    </Segment>
  );
};

export default  WatchlistFacial;
