import { RefObject } from "react";
import { AddWidgetFunc, LayoutType } from "components/Layout";
import { ModuleInfo, ViewLayoutItem, ViewLayoutItemType, ViewLayoutItemOrientation } from "@core/types";
import { ViewWidgetProps } from "components/Widgets";
import {__} from "@solid/libs/i18n";

import IconSingle from "./images/single.svg";
import Icon2x2 from "./images/2x2.svg";
import Icon3x2 from "./images/3x2.svg";
import Icon3x3 from "./images/3x3.svg";
import Icon1_5 from "./images/1_5.svg";

export enum ViewLayoutId {
  ViewSingle = "ViewSingle",
  View2x2 = "View2x2",
  View3x2 = "View3x2",
  View3x3 = "View3x3",
  View1_5 = "View1_5"
}

export type ViewLayoutInfo = {
  id: ViewLayoutId;
  name: string;
  module: string;
  hasLayout?: boolean;
  icon: string;
  layout: ViewLayoutItem[];
};

export const ViewLayouts: ViewLayoutInfo[] = [
  { id: ViewLayoutId.ViewSingle, name: __("Single Tile"), module: "ViewLayouts/ViewCustom", hasLayout: true, icon: IconSingle, layout: [
    { type: ViewLayoutItemType.Cell, size: 1.0, },
  ] },

  { id: ViewLayoutId.View2x2, name: __("2 x 2 Tile Layout"), module: "ViewLayouts/ViewCustom", hasLayout: true, icon: Icon2x2, layout: [
    { type: ViewLayoutItemType.Split, orientation: ViewLayoutItemOrientation.Vertical, size: 1.0, items: [
      { type: ViewLayoutItemType.Split, orientation: ViewLayoutItemOrientation.Horizontal, size: 0.5, items: [
        { type: ViewLayoutItemType.Cell, size: 0.5 },
        { type: ViewLayoutItemType.Cell, size: 0.5 },
      ] },
      { type: ViewLayoutItemType.Split, orientation: ViewLayoutItemOrientation.Horizontal, size: 0.5, items: [
        { type: ViewLayoutItemType.Cell, size: 0.5 },
        { type: ViewLayoutItemType.Cell, size: 0.5 },
      ] },
    ] }
  ] },

  { id: ViewLayoutId.View3x2, name: __("3 x 2 Tile Layout"), module: "ViewLayouts/ViewCustom", hasLayout: true, icon: Icon3x2, layout: [
    { type: ViewLayoutItemType.Split, orientation: ViewLayoutItemOrientation.Vertical, size: 1.0, items: [
      { type: ViewLayoutItemType.Split, orientation: ViewLayoutItemOrientation.Horizontal, size: 0.5, items: [
        { type: ViewLayoutItemType.Cell, size: 0.3 },
        { type: ViewLayoutItemType.Cell, size: 0.3 },
        { type: ViewLayoutItemType.Cell, size: 0.3 },
      ] },
      { type: ViewLayoutItemType.Split, orientation: ViewLayoutItemOrientation.Horizontal, size: 0.5, items: [
        { type: ViewLayoutItemType.Cell, size: 0.3 },
        { type: ViewLayoutItemType.Cell, size: 0.3 },
        { type: ViewLayoutItemType.Cell, size: 0.3 },
      ] },
    ] }
  ] },

  { id: ViewLayoutId.View3x3, name: __("3 x 3 Tile Layout"), module: "ViewLayouts/ViewCustom", hasLayout: true, icon: Icon3x3, layout: [
    { type: ViewLayoutItemType.Split, orientation: ViewLayoutItemOrientation.Vertical, size: 1.0, items: [
      { type: ViewLayoutItemType.Split, orientation: ViewLayoutItemOrientation.Horizontal, size: 0.3, items: [
        { type: ViewLayoutItemType.Cell, size: 0.3 },
        { type: ViewLayoutItemType.Cell, size: 0.3 },
        { type: ViewLayoutItemType.Cell, size: 0.3 },
      ] },
      { type: ViewLayoutItemType.Split, orientation: ViewLayoutItemOrientation.Horizontal, size: 0.3, items: [
        { type: ViewLayoutItemType.Cell, size: 0.3 },
        { type: ViewLayoutItemType.Cell, size: 0.3 },
        { type: ViewLayoutItemType.Cell, size: 0.3 },
      ] },
      { type: ViewLayoutItemType.Split, orientation: ViewLayoutItemOrientation.Horizontal, size: 0.3, items: [
        { type: ViewLayoutItemType.Cell, size: 0.3 },
        { type: ViewLayoutItemType.Cell, size: 0.3 },
        { type: ViewLayoutItemType.Cell, size: 0.3 },
      ] },
    ] }
  ] },

  { id: ViewLayoutId.View1_5, name: __("1 + 5 Tile Layout"), module: "ViewLayouts/ViewCustom", hasLayout: true, icon: Icon1_5, layout: [
    { type: ViewLayoutItemType.Split, orientation: ViewLayoutItemOrientation.Vertical, size: 1.0, items: [
      { type: ViewLayoutItemType.Split, orientation: ViewLayoutItemOrientation.Horizontal, size: 0.6, items: [
        { type: ViewLayoutItemType.Cell, size: 0.6025 },
        { type: ViewLayoutItemType.Split, orientation: ViewLayoutItemOrientation.Vertical, size: 0.3, items: [
          { type: ViewLayoutItemType.Cell, size: 0.5 },
          { type: ViewLayoutItemType.Cell, size: 0.5 },
        ] },
      ] },
      { type: ViewLayoutItemType.Split, orientation: ViewLayoutItemOrientation.Horizontal, size: 0.3, items: [
        { type: ViewLayoutItemType.Cell, size: 0.3 },
        { type: ViewLayoutItemType.Cell, size: 0.3 },
        { type: ViewLayoutItemType.Cell, size: 0.3 },
      ] },
    ] }
  ] },
];

export type ViewProps = {
  viewId: string;
  name: string;
  index?: number;
  widgets?: ModuleInfo[];
  layout?: ViewLayoutItem[];
  layoutRef?: RefObject<LayoutType>;
  widgetClass?: string;
  addWidget?: AddWidgetFunc;
} & ViewWidgetProps;

export { default as ViewLayout } from "./ViewLayout";
