import React, { useState, useEffect } from "react";
import { Button, Segment, Popup } from "semantic-ui-react";
import { ReactSVG } from "react-svg";
import { withStore, WithStoreProps } from "@core/store";
import { CreatingView, CreatingViewInput } from "@generated/graphql";
import { queryToInput } from "utils";
import { ViewTemplates, ViewTemplateId } from "components/View/SelectTemplate";
import {__} from "@solid/libs/i18n";

import "./style.css";

type SelectTemplateProps = WithStoreProps & {
  viewId: string;
};

const SelectTemplate = ({ viewId, store: { workspace: { creatingViews } }, setStore }: SelectTemplateProps) => {
  const [popupOpen, setPopupOpen] = useState(false);

  useEffect(() => {
    window.requestAnimationFrame(() => setTimeout(() => setPopupOpen(true), 100));
  }, []);

  function select(template: ViewTemplateId): void {
    if (creatingViews) {
      const newViews = queryToInput<CreatingView[], CreatingViewInput[]>(creatingViews);
      const index = newViews.findIndex(item => item.viewId === viewId);
      if (index >= 0) {
        newViews[index] = { ...newViews[index], template };
        setStore({ workspace: { creatingViews: newViews } });
      }
    }
  }

  return (
    <Segment className="SelectTemplate-Root">
      <div className="SelectTemplate-Main">
        <Popup open={popupOpen} content={__("Select view template from the options below")} position="top center" offset={[0, 20]} trigger={
          <div>
            { ViewTemplates.map(({id, title, icon }) =>
              <Button key={id} onClick={() => select(id)}><ReactSVG role="large-icon" src={icon}/>{title}</Button>) }
          </div>
        }/>
      </div>
    </Segment>
  );
};

export default withStore(SelectTemplate);
