import { ModuleInfo } from "@core/types";
import { UUID } from "@solid/types";
import { CreatingView } from "@generated/graphql";
import {__} from "@solid/libs/i18n";

export function validateViewName(
  viewId: string,
  name: string,
  allViews: ModuleInfo[],
  creatingViews?:
  CreatingView[] | null,
  userId?: UUID,
  saveAs?: boolean,
  share?: boolean): string {
  if (!name || !name.trim()) {
    return __("View name should be not empty.");
  }

  const linkedShared = share ? allViews.find(v => v.originalViewId === viewId && v.userId === userId && v.isShared && !v.isSystem && v.name === name) : undefined;

  if ((creatingViews
      && creatingViews.some(v => v.viewId !== viewId && v.name.trim().toUpperCase() === name.trim().toUpperCase()))
      || allViews.some(v => ((v.id !== viewId && !v.isShared) || saveAs || v.isSystem || (v.isShared && v.userId !== userId)) &&
      v.name.trim().toUpperCase() === name.trim().toUpperCase() && v.id !== linkedShared?.id)) {
    return __("View with the same name already exists.");
  }
  return "";
}
