import React from "react";
import { List } from "semantic-ui-react";
import { ViewManagerResult } from "components/View";
import {__} from "@solid/libs/i18n";
import ViewButton from "./ViewButton";

import "./style.css";

type SharedViewListProps = {
  vm: ViewManagerResult;
  filter?: string;
};

const SharedViewList = ({ vm, filter }: SharedViewListProps) => {
  const { config: { allViews } } = vm;
  return (
    <div className="ViewList">
      <List className="ViewList-ButtonPanel">
        { allViews.filter(v => v.isShared && (!filter || v.name.toLocaleUpperCase().includes(filter.toLocaleUpperCase())))
          .sort((a, b) => a.name.localeCompare(b.name, undefined, { sensitivity: "base" }))
          .map(view => <ViewButton key={view.id} view={view} vm={vm}/>) }
      </List>
    </div>
  );
};

export default SharedViewList;
