import React from "react";
import { ViewManagerResult } from "components/View";
import { List } from "semantic-ui-react";
import {__} from "@solid/libs/i18n";
import ViewButton from "./ViewButton";

import "./style.css";

type RecentViewListProps = {
  vm: ViewManagerResult;
};

const RecentViewList = ({ vm }: RecentViewListProps) => {
  const { config: { recentViews } } = vm;
  return (
    <div className="ViewList">
      <List className="ViewList-ButtonPanel">
        { recentViews.map(view =>
          <ViewButton key={view.id} view={view} vm={vm} editDisabled shareDisabled deleteDisabled/>) }
      </List>
    </div>
  );
};

export default RecentViewList;
