import React from "react";
import { Modal, Button, Icon, Header } from "semantic-ui-react";
import { ModuleInfo } from "@core/types";
import {__} from "@solid/libs/i18n";

type CloseConfirmProps = {
  view: ModuleInfo;
  onConfirm: (id: string) => void;
  onCancel: (id: string) => void;
};

const CloseConfirm = ({ view: { id, name }, onConfirm, onCancel }: CloseConfirmProps) => {
  return (
    <Modal open onClose={() => onCancel(id)}>
      <Header>{__("Unsaved Changes")}</Header>
      <Modal.Content>
        {__("View '{{name}}' has unsaved changes.", {name})}
        <br/>
        {__("Are you sure you want to discard the changes?")}
      </Modal.Content>
      <Modal.Actions>
        <Button negative onClick={() => onConfirm(id)}>
          <Icon name="undo"/>{__("Discard")}
        </Button>
        <Button onClick={() => onCancel(id)}>
          <Icon name="cancel"/>{__("Cancel")}
        </Button>
      </Modal.Actions>
    </Modal>
  );
};

export default CloseConfirm;
