import React, { useCallback, useMemo, useRef, useState } from "react";
import { useStore } from "@core/store";
import { Segment } from "semantic-ui-react";
import classNames from "classnames";
import { UUID } from "@solid/types";
import { origin } from "@core/api";

import "./style.css";

const VideoWalls = () => {
  const { store: { session: { info } } } = useStore();
  const [loading, setLoading] = useState<boolean>(true);
  const realmId: UUID | undefined = useMemo(() => { return info?.realm.id; }, [info]);
  const iframeRef = useRef<HTMLIFrameElement>(null!);

  const onLoad = useCallback(() => {
    if (!realmId) {
      return;
    }

    if (iframeRef.current.contentWindow) {
      const solidUINotification = iframeRef.current.contentWindow.document.querySelector("#system-solid-ui-notification") as HTMLElement;
      if (solidUINotification) {
        solidUINotification.style.display = "none";
      }
      const statusFlag = iframeRef.current.contentWindow.document.querySelector("#status-flag") as HTMLElement;
      if (statusFlag) {
        statusFlag.style.display = "none";
      }
      const menu = iframeRef.current.contentWindow.document.querySelector(".menu") as HTMLElement;
      if (menu) {
        menu.style.display = "none";
      }

      setLoading(false);
    }
  }, [realmId]);

  return (
    <Segment className={classNames("Video-Walls-Root", { loading })}>
      {realmId &&
        <iframe
          id="VideoWalls"
          className="Video-Walls"
          src={`${origin}/sdi/admin/#vmx_${realmId}`}
          frameBorder="0"
          title="VideoWalls"
          ref={iframeRef}
          onLoad={() => onLoad()}/>
      }
    </Segment>
  );
};

export default VideoWalls;
