import React from "react";
import { /*Checkbox,*/ Form } from "semantic-ui-react";
import { FilterPropType, periodOptions, requestTypeOptions, statusOptions, VDMFilterState, VDMRequestStatus } from "@core/actions/videoDelivery";
import { AodRequestType } from "@generated/graphql";
import { __ } from "@solid/libs";

import "./style.css";

type VDMFilterControlsProps = {
  filter: VDMFilterState,
  disabled: boolean,
  onFilterChange: (newFilterValue: FilterPropType, key: keyof VDMFilterState) => void;
};

const VDMFilterControls = ({ filter, disabled, onFilterChange }: VDMFilterControlsProps) => {
  const { interval, status, type, searchText, /*onlyEvents*/ } = filter;

  return (
    <div className="VDMFilterControls">
      <Form.Select
        className="VDMFilterControls-Dropdown"
        label={__("Period")}
        options={periodOptions}
        value={interval}
        disabled={disabled}
        onChange={(e, {value}) => {
          e.preventDefault();
          onFilterChange(value as number, "interval");
        }}
        />
      <Form.Select
        className="VDMFilterControls-Dropdown"
        label={__("Status")}
        options={statusOptions}
        value={status}
        disabled={disabled}
        onChange={(e, {value}) => {
          e.preventDefault();
          onFilterChange(value as VDMRequestStatus, "status");
        }}
        />
      <Form.Select
        className="VDMFilterControls-Dropdown"
        label={__("Type")}
        options={requestTypeOptions}
        value={type}
        disabled={disabled}
        onChange={(e, {value}) => {
          e.preventDefault();
          onFilterChange(value as AodRequestType, "type");
        }}
        />
      <Form.Input
        className="VDMFilterControls-Input"
        label={__("Filter by text")}
        value={searchText}
        disabled={disabled}
        onChange={(e, {value}) => {
          e.preventDefault();
          onFilterChange(value as string, "searchText");
        }}
        />
      {/* <div className="VDMFilterControls-Checkbox">
        <Form.Field label={__("Events only")} />
        <Checkbox
          toggle
          checked={onlyEvents}
          disabled={disabled}
          onChange={(e, data) => {
            e.preventDefault();
            onFilterChange(!!data.checked, "onlyEvents");
          }}
          />
      </div> */}
    </div>
  );
};

export default VDMFilterControls;
