import React, { useMemo } from "react";
import { __ } from "@solid/libs/i18n";
import { AodRequest, AodRequestStatus } from "@generated/graphql";
import { FilterPropType, VDMContentType, VDMFilterState } from "@core/actions/videoDelivery";
import VDMFilterControls from "./VDMFilterControls";
import VDMContentControls from "./VDMContentControls";
import VDMDownloadControls from "./VDMDownloadControls";

import "./style.css";

type VDMControlsProps = {
  filter: VDMFilterState;
  pending: boolean;
  controlType: VDMContentType;
  onFilterChange: (newFilterValue: FilterPropType, key: keyof VDMFilterState) => void;
  onBack: () => void;
  rowData?: AodRequest;
  cancelAll: () => Promise<void>
};

const cancelledStatus = [AodRequestStatus.Processing, "ALL"];

const VDMControls = React.memo(({ filter, onFilterChange, pending, onBack, rowData, controlType, cancelAll }: VDMControlsProps) => {
  const disabled: boolean = useMemo(() => {
    const { status } = filter;
    return cancelledStatus.indexOf(status) === -1;
  }, [filter]);

  return (
    <div className="VDMControls">
      {controlType === VDMContentType.Download ?
        <VDMDownloadControls onBack={onBack} rowData={rowData} /> :
        <>
          <VDMFilterControls filter={filter} onFilterChange={onFilterChange} disabled={pending} />
          <VDMContentControls disabled={pending || disabled} cancelAll={cancelAll} />
        </>}
    </div>
  );
});

export default VDMControls;
