import React from "react";
import { Button, Header, Icon } from "semantic-ui-react";
import { __ } from "@solid/libs/i18n";

import "./style.css";

type VDMConfirmProp = {
  title: string;
  confirmButtonText: string;
  onConfirm: () => void;
  onCancel: () => void;
};

const VDMConfirm = ({ title, confirmButtonText, onConfirm, onCancel }: VDMConfirmProp) => {
  return (
    <div className="VDMConfirm">
      <Header.Content>{title}</Header.Content>
      <div className="VDMConfirm-Buttons">
        <Button
          color="green"
          onClick={() => onCancel()}
        >
          <Icon name="cancel" />
          {__("Cancel")}
        </Button>
        <Button
          color="red"
          onClick={(e: React.MouseEvent) => {
            e.stopPropagation();
            onConfirm();
          }}
        >
          <Icon name="trash" />
          {confirmButtonText}
        </Button>
      </div>
    </div>
  );
};

export default VDMConfirm;
