import React from "react";
import { Progress } from "semantic-ui-react";
import { __ } from "@solid/libs";
import { formatDownloadingTime } from "@core/actions/videoDelivery";

import "./style.css";

type VDMRequestProgressProp = {
  size?: number | null;
  downloaded?: number | null;
  eta?: number | null;
};

const VDMRequestProgress = ({ size, downloaded, eta }: VDMRequestProgressProp) => {
  const percent = typeof size === "number" && typeof downloaded === "number" && size !== 0 && downloaded !== 0
    ?  (downloaded  * 100) / size : 0;
  return (
    <div className="VDMRequestProgress">
      <Progress percent={percent} active color="green" >
        <span className="VDMRequestProgress-Eta">{formatDownloadingTime(eta)}</span>
      </Progress>
    </div>

  );
};

export default VDMRequestProgress;
