import React from "react";
import { Icon, List } from "semantic-ui-react";
import { AodRequestFilesListEntry } from "@generated/graphql";
import  { downloadOne, formatBytes } from "@core/actions/videoDelivery";

import "./style.css";

type VDMCellSizeProp = {
  rowData: AodRequestFilesListEntry;
  deviceId: string;
};

const VDMCellSize = ({ rowData, deviceId }: VDMCellSizeProp) => {
  return (
    <List.Description
      className="VDMCellContent-ListItemLink"
      onClick={(e: React.MouseEvent) => {
        e.preventDefault();
        downloadOne(rowData);
      }} >
      <Icon name="cloud download" />
      <span className="VDMCellContent-ListItemSize">
        { formatBytes(rowData.size) || "" }
      </span>
    </List.Description>
  );
};

export default VDMCellSize;
