import React from "react";
import { FontAwesomeIcon } from "@fortawesome/react-fontawesome";
import useVideoDelivery from "@core/actions/videoDelivery";
import { AodRequest, HealthStatus } from "@generated/graphql";
import { __ } from "@solid/libs";

import "./style.css";
import classNames from "classnames";

type VDMCellDeviceNameProp = {
  rowData: AodRequest;
};

const VDMCellDeviceName = ({ rowData }: VDMCellDeviceNameProp) => {
  const { getDeviceItem } = useVideoDelivery({});
  const device = getDeviceItem(rowData);
  const disabled = !device?.enabled || device.healthStatus !== HealthStatus.Normal;
  return (
    <div className={classNames("VDMCellDeviceName", { "_disabled": disabled })}>
      {device ?
        <>
          <FontAwesomeIcon icon={!disabled ? "video" : "video-slash"} />
          <div className="VDMCell-DeviceName">{device.name}</div>
        </> :
        __("Device not found")
      }
    </div>
  );
};

export default VDMCellDeviceName;
