import React from "react";
import { AodRequest, AodRequestFilesListEntry, AodRequestStatus } from "@generated/graphql";
import { __ } from "@solid/libs";
import useVideoDelivery, { VDMContentType } from "@core/actions/videoDelivery";
import VDMRequestProgress from "./VDMRequestProgress";
import VDMCellActions from "./VDMCellActions";
import VDMCellSize from "./VDMCellSize";
import VDMCellDeviceName from "./VDMCellDeviceName";

import "./style.css";

type VDMCellContentProps = {
  dataKey: string;
  request?: AodRequest;
  downloadFile?: AodRequestFilesListEntry;
  onDownloadsOpen?: (rowData: AodRequest) => void;
  updateRequests?: (requests: AodRequest[]) => void;
};

const VDMCellContent = ({ dataKey, request, downloadFile, onDownloadsOpen, updateRequests }: VDMCellContentProps) => {
  const { getCellContentText } = useVideoDelivery({});

  if (request && dataKey === "deviceName") {
    return <VDMCellDeviceName rowData={request} />;
  }

  if (downloadFile && dataKey === "size" && request) {
    return <VDMCellSize rowData={downloadFile} deviceId={request.deviceId} />;
  }

  if (request && dataKey === "action") {
    return <VDMCellActions rowData={request} onDownloadsOpen={onDownloadsOpen} updateRequests={updateRequests} />;
  }

  if (dataKey === "status" && request && [AodRequestStatus.Processing, AodRequestStatus.Exporting].indexOf(request.status) !== -1) {
    return <VDMRequestProgress downloaded={request.downloaded} size={request.size} eta={request.eta}/>;
  }

  return (
    <div className="VDMCellContent">
      { request && getCellContentText({ dataKey, data: { content: VDMContentType.Request, rowData: request } }) }
      { downloadFile && getCellContentText({ dataKey, data: { content: VDMContentType.Download, rowData: downloadFile } }) }
    </div>
  );
};

export default VDMCellContent;
