import {ApiError, UUID} from "@solid/types";
import {VMXWall, VMXCell, VMXNewCell, VMXCellUpdate} from "@libs/vmx";
import {origin} from "core/api";

export function fetchVMXWalls(id: UUID): Promise<VMXWall[]> {
  const data = fetch(`${origin}/api/vmx2/wall`)
    .then((res: any) => res.json())
    .then(data => data.descriptors)
    .catch((error: ApiError) => {
      console.error(`[${error.code}] ${error.message}`);
      // throw error;
    });
  return data;
}

export function fetchVMXWall(id: UUID) {
  return fetch(`${origin}/api/vmx2/wall/${id}`)
    .then((res: any) => res.json())
    .catch((error: ApiError) => {
      console.error(`[${error.code}] ${error.message}`);
      // throw error;
    });
}

export function fetchVMXCells(wall_id: UUID) {
  return fetch(`${origin}/api/vmx2/wall/${wall_id}/content`)
    .then((res: any) => res.json())
    .catch((error: ApiError) => {
      console.error(`[${error.code}] ${error.message}`);
      // throw error;
    });
}

export function updateVMXCells(wall_id: UUID, cells: (VMXCell | VMXNewCell)[]) {
  const data = {
    "cells": {
      "descriptors": cells
    }
  };
  return fetch(`${origin}/api/vmx2/wall/${wall_id}/content`, {
    method: "PUT",
    headers: {
      "Content-Type": "application/json"
    },
    body: JSON.stringify(data)
  })
    .then((res: any) => res.json())
    .catch((error: ApiError) => {
      console.error(`[${error.code}] ${error.message}`);
      // throw error;
    });
}

export function updateVMXCell(wall_id: UUID, cell_id: UUID, cell: VMXCellUpdate) {
  return fetch(`${origin}/api/vmx2/wall/${wall_id}/content/${cell_id}`, {
    method: "PUT",
    headers: {
      "Content-Type": "application/json"
    },
    body: JSON.stringify(cell)
  })
    .then((res: any) => res.json())
    .catch((error: ApiError) => {
      console.error(`[${error.code}] ${error.message}`);
      // throw error;
    });
}
