import React, { useRef, useState } from "react";
import { Segment } from "semantic-ui-react";
import classNames from "classnames";
import { origin } from "@core/api";

import "./style.css";

const Subscription = () => {
  const [loading, setLoading] = useState<boolean>(true);
  const iframeRef = useRef<HTMLIFrameElement>(null!);

  const onLoad = () => {
    if (!iframeRef.current.contentWindow) {
      console.error("!iframeRef.current.contentWindow");
      return;
    }
    setLoading(false);
  };

  return (
    <Segment className={classNames("Subscription-Root", { loading })}>
      <iframe
        id="Subscription"
        className="Subscription"
        src={`${origin}/sdi/about/licensing.php`}
        frameBorder="0"
        title="Subscription"
        ref={iframeRef}
        onLoad={() => onLoad()}/>
    </Segment>
  );
};

export default Subscription;
