import React from "react";
import { Popup } from "semantic-ui-react";
import { FontAwesomeIcon } from "@fortawesome/react-fontawesome";
import {__} from "@solid/libs/i18n";

import "./style.css";

type StatusTitleProps = {
  title?: React.ReactNode;
  loading?: boolean;
  loadingText?: string;
  error?: Error;
  errorContent?: JSX.Element;
};

const StatusTitle = ({ title, loading, loadingText, error, errorContent }: StatusTitleProps) => {
  return (
    <>
      <span className="StatusTitle">{title}</span>
      { !!loading &&
      <Popup content={loadingText ?? __("Loading...")} trigger={
        <span><FontAwesomeIcon className="StatusTitle-LoadingIcon" icon="cog" spin/></span>
      }/> }
      { !!error &&
      <Popup className="ui error message StatusTitle-ErrorPopup"
        content={errorContent ?? error.message}
        trigger={
          <span><FontAwesomeIcon className="StatusTitle-WarningIcon" icon="exclamation-triangle"/></span>
        }
      /> }
    </>
  );
};

export default StatusTitle;
