import React from "react";
import { Segment, Checkbox } from "semantic-ui-react";
import { useConfig } from "@core/store/actions";
import {__} from "@solid/libs/i18n";

import "./style.css";
import { isElectron } from "@solid/libs";

const SettingsActivity = () => {
  const { settings, setConfig } = useConfig();

  return (
    <Segment className="SettingsActivity">
      <div>{__("Application Settings")}</div>
      <hr/>
      <div className="SettingsActivity__openViewListOnStart">
        <Checkbox
          className="SettingsActivity-Checkbox"
          label={__("Open view list on start")}
          checked={!!settings.openViewListOnStart}
          onChange={(e, data) => setConfig({ settings: { ...settings, openViewListOnStart: data.checked } })}
          toggle
          />
      </div>
      {isElectron() &&
      <div className="SettingsActivity__saveCurrentSession">
        <Checkbox
          className="SettingsActivity-Checkbox"
          label={__("Save current session")}
          checked={settings.saveCurrentSession}
          defaultChecked
          onChange={(e, data) => setConfig({ settings: { ...settings, saveCurrentSession: data.checked } })}
          toggle
          />
      </div>}
    </Segment>
  );
};

export default SettingsActivity;
