import React, {useEffect} from "react";
import {useNavigate} from "react-router-dom";
import {Header, Image} from "semantic-ui-react";
import {useStore} from "@core/store";
import {useSetUserRealmMutation, useUserRealmsQuery} from "@generated/graphql";
import WithQueryStatus from "components/WithQueryStatus";
import {__} from "@solid/libs/i18n";

import "./style.css";

const SelectRealm = () => {
  const navigate = useNavigate();
  const {store: {session: {isLoggedIn, info}}} = useStore();
  const {data, loading, error} = useUserRealmsQuery();
  const [setUserRealm] = useSetUserRealmMutation();

  const realm = info?.realm.id;

  useEffect(() => {
    if (!!data?.userRealms && data?.userRealms.length <= 1) {
      next();
    }
  }, [data]);

  function next() {
    navigate("/guilist");
  }

  function chooseRealm(realmId: string): any | undefined {
    if (realmId && info?.user.name && info?.realm.id !== realm) {
      setUserRealm({variables: {userName: info?.user.name, realmId}}).then(
        (res) => {
          next();
        }
      );
    } else next();
  }

  return (
    <WithQueryStatus loading={loading} error={error} noData={!data}>
      {isLoggedIn &&
      <div className="select-realm-container">
        <div className="select-realm-header">
          <Header size="huge">{__("Select a Realm to enter")}</Header>
        </div>
        <div className="realm-list">
          {data?.userRealms.map(realm =>
            <div key={realm.id} className="current-realms" onClick={() => chooseRealm(realm.id)}>
              <div className="current-realm-image">
                <Image src="/resources/images/icon.ico" size="tiny" />
              </div>
              <div className="current-realm-name">
                <Header size="tiny">{realm.name}</Header>
              </div>
            </div>
          )}
        </div>
      </div>
        }
    </WithQueryStatus>
  );
};

export default SelectRealm;
