import React, {useEffect, useState} from "react";
import {useStore} from "@core/store";
import {__, getOrigin} from "@solid/libs";
import {Document, Page, pdfjs} from "react-pdf";
import {Button} from "semantic-ui-react";

import "./style.css";

pdfjs.GlobalWorkerOptions.workerSrc = "pdf.worker.min.js";

const QuickStart = () => {
  const { store: { branding } } = useStore();
  const [pdfUrl, setPdfUrl] = useState("");

  useEffect(() => {
    if (!branding) {
      return;
    }

    setPdfUrl(getOrigin() + branding.QUICK_START_GUIDE_PATH);
  }, [branding]);

  const [numPages, setNumPages] = useState<number>(0);

  function onDocumentLoadSuccess({ numPages }: {numPages: number}) {
    setNumPages(numPages);
  }

  function onDownloadClick() {
    const link = document.createElement("a");

    link.setAttribute("href", pdfUrl);
    link.setAttribute("download", "some.pdf");
    document.body.appendChild(link);

    link.click();
    link.remove();
  }

  return (
    <div className="all-page-container">
      <Button icon="download" content={__("Download")} onClick={() => onDownloadClick()}/>
      {pdfUrl &&
      <Document file={pdfUrl} onLoadSuccess={onDocumentLoadSuccess}>
        {Array.from(new Array(numPages), (el, index) => (
          <Page key={`page_${index + 1}`} pageNumber={index + 1} width={800}/>
        ))}
      </Document>}
    </div>
  );
};

export default QuickStart;
