import React, { useState } from "react";
import { Icon, Popup } from "semantic-ui-react";

import { __ } from "@solid/libs";

import "./style.css";

type PointMenuProps = {
  children?: React.ReactElement,
};

const PointMenu = ({ children }: PointMenuProps) => {
  const [menuVisible, setMenuVisible] = useState<boolean>(false);

  return (
    <div
      className="PointMenu"
    >
      { menuVisible &&
        <div className="PointMenu-Menu">
          {children}
        </div> }

      <Popup
        content={menuVisible ? __("Hide menu") : __("Show Menu")}
        position="bottom right"
        trigger={
          <Icon
            className="PointMenu-Trigger"
            name="ellipsis vertical"
            onClick={() => setMenuVisible(!menuVisible)} />
        } />
    </div>
  );
};

export default PointMenu;
