import React from "react";
import PlayerCellLegacy from "@solid/player-cell/components/PlayerCellLegacy";
import {useParams} from "react-router-dom";
import {UUID} from "@solid/types";

import "./style.css";

type MatrixParams = {
  cameraId?: UUID,
  timestamp?: string
};

const Matrix = () => {
  const params = useParams<MatrixParams>();

  const cameraId = params.cameraId ?? "";
  const time = params.timestamp && !isNaN(Number(params.timestamp)) ? new Date(Number(params.timestamp)) : undefined;

  return (
    <div className="matrix">
      <PlayerCellLegacy obj={cameraId} time={time} header="Player Test" isArchive stepBackControl onClose={() => { console.log("oncellclose"); }}/>
    </div>
  );
};

export default Matrix;
