import classNames from "classnames";
import React, { useRef, useState} from "react";
import { Segment } from "semantic-ui-react";
import {origin} from "@core/api";
import { useDeviceActions } from "@core/actions";

import "./style.css";

const ManageAvatars = () => {
  const [loading, setLoading] = useState<boolean>(true);
  const { deleteCachedDevice } = useDeviceActions({ skipSubscription: true });
  const iframeRef = useRef<HTMLIFrameElement>(null!);

  const getTabsMenu = (iframe: HTMLIFrameElement, childIndex: number) => {
    if (!iframe.contentWindow) {
      return undefined;
    }
    const tabs = iframe.contentWindow.document.getElementsByClassName("tabs_menu")[0];
    return tabs.children[childIndex] as HTMLElement;
  };

  const onLoad = () => {
    if (!iframeRef.current.contentWindow) {
      console.error("!iframeRef.current.contentWindow");
      return;
    }
    (iframeRef.current.contentWindow as Window & {onEditorLoad: () => void}).onEditorLoad = () => {
      const avatarActivateTab = getTabsMenu(iframeRef.current, 0);
      if (avatarActivateTab) {
        avatarActivateTab.style.display = "none";
      }

      setLoading(false);
    };

    (iframeRef.current.contentWindow as Window & {onAvatarDelete: (id: string) => void}).onAvatarDelete = (avatarId: string) => {
      deleteCachedDevice(avatarId);
    };
  };

  return (
    <Segment className={classNames("Manage-Avatars-Root", { loading })}>
      <iframe
        id="ManageAvatars"
        className="Manage-Avatars"
        src={`${origin}/sdi/avatar/avatar.php#!/avatar_migrate`}
        frameBorder="0"
        title="ManageAvatars"
        ref={iframeRef}
        onLoad={() => onLoad()}
      />
    </Segment>
  );
};

export default ManageAvatars;
