import React, { Suspense, LazyExoticComponent, lazy, Ref } from "react";
import Loading from "components/Loading";

const lazyComponent = (Component: LazyExoticComponent<any>, componentProps?: object, forwardRef?: boolean) => {
  return React.forwardRef((props: {}, ref: Ref<any>) => {
    return (
      <Suspense fallback={<Loading/>}>
        { !!forwardRef && <Component {...componentProps} ref={ref} /> }
        { !forwardRef && <Component {...componentProps} /> }
      </Suspense>
    );
  });
};

type LazyComponentProps = {
  render: () => Promise<{ default: any }>;
  props?: object;
  forwardRef?: boolean;
};

const LazyComponent = React.forwardRef(({ render, props, forwardRef }: LazyComponentProps, ref: Ref<any>) => {
  const Component = lazyComponent(lazy(render), props, forwardRef);
  return <Component ref={ref} />;
});

export default LazyComponent;
