import React from "react";

type WidgetErrorBoundaryState = {
  hasError: boolean;
  error: { message: string, stack: string };
  info: { componentStack: string };
};

class WidgetErrorBoundary extends React.PureComponent<{}, WidgetErrorBoundaryState> {
  constructor(props: any) {
    super(props);
    this.state = {
      hasError: false,
      error: {message: "", stack: ""},
      info: {componentStack: ""}
    };
  }

  override componentDidCatch(error: any, info: any) {
    this.setState({
      hasError: true,
      error,
      info
    });
    console.error(error, info);
  }

  override render() {
    if (this.state.hasError) {
      return (
        <div className="error">
          <div>{this.state.error.message}</div>
          stack: <details>{this.state.error.stack}</details>
          componentStack: <details>{this.state.info.componentStack}</details>
        </div>
      );
    }
    return this.props.children;
  }
}

export default WidgetErrorBoundary;
