import React from "react";
import { Modal, Header, Button } from "semantic-ui-react";
import LabelEditor from "components/LabelsAndHierarchies/LabelEditor";
import {__} from "@solid/libs/i18n";

import "./style.css";

type LabelEditorDialogProps = {
  open: boolean;
  onClose: () => void;
  showBackButton?: boolean;
};

const LabelEditorDialog = ({ open, onClose, showBackButton }: LabelEditorDialogProps) => {
  return (
    <Modal className="LabelEditorDialog" open={open} onClose={onClose} closeIcon={!showBackButton} size="large" closeOnEscape={false}>
      <Header>
        {!!showBackButton &&
        <div className="LabelEditorDialog-Back">
          <Button onClick={onClose}>{__("Back")}</Button>
        </div>}
        {__("Edit Labels")}
      </Header>
      <Modal.Content>
        <LabelEditor/>
      </Modal.Content>
    </Modal>
  );
};

export default LabelEditorDialog;
