import React, { useRef } from "react";
import { Modal, Header } from "semantic-ui-react";
import HierarchyEditor, { HierarchyEditorEvent } from "components/LabelsAndHierarchies/HierarchyEditor";
import {__} from "@solid/libs/i18n";

import "./style.css";

type HierarchyEditorDialogProps = {
  open: boolean;
  onClose: () => void;
  hierarchyId?: string;
};

const HierarchyEditorDialog = ({ open, onClose, hierarchyId }: HierarchyEditorDialogProps) => {
  const closeEventRef = useRef(new HierarchyEditorEvent());

  function close(): void {
    closeEventRef.current.publish({ close: onClose });
  }

  return (
    <Modal className="HierarchyEditorDialog" open={open} onClose={close} closeIcon size="large" closeOnEscape={false}>
      <Header content={__("Edit Hierarchy")}/>
      <Modal.Content>
        <HierarchyEditor hierarchyId={hierarchyId} closeEvent={closeEventRef.current}/>
      </Modal.Content>
    </Modal>
  );
};

export default HierarchyEditorDialog;
