import React from "react";
import { Icon, Popup, SemanticICONS, PopupProps } from "semantic-ui-react";
import classNames from "classnames";
import { PropType } from "utils";

import "./style.css";

type IconButtonProps = {
  icon: SemanticICONS;
  hint?: string;
  disabled?: boolean;
  hintPosition?: PopupPosition;
  onClick?: () => void;
};

type PopupPosition = PropType<PopupProps, "position">;

const IconButton = ({ icon, hint, disabled = false, hintPosition, onClick }: IconButtonProps) => {
  return (
    <Popup
      trigger={
        <Icon name={icon} className={classNames("IconButton", { disabled })} onClick={!disabled ? onClick : undefined}/>
      }
      content={hint}
      disabled={disabled || !hint}
      position={hintPosition}
    />
  );
};

export default IconButton;
