import React, { useState } from "react";
import { Icon, Portal, Segment } from "semantic-ui-react";
import ReactMarkdown from "react-markdown";

import "./style.css";

/* eslint-disable react/no-children-prop */

type HelpProps = {
  markdown: string;
};

const Help = ({ markdown }: HelpProps) => {
  const [open, setOpen] = useState(false);

  return (
    <>
      <div className="HelpButton">
        <Icon name="help circle" size="big" onClick={() => setOpen(true)}/>
      </div>

      <Portal open={open} onClose={() => setOpen(false)}>
        <Segment className="Help">
          <ReactMarkdown children={markdown}/>
          <div className="HelpCloseButton">
            <Icon name="close" onClick={() => setOpen(false)}/>
          </div>
        </Segment>
      </Portal>
    </>
  );
};

export default Help;
