import { WithStoreProps, withStore } from "@core/store";
import { WidgetProps, Widgets } from "components/Widgets";
import React, { useCallback } from "react";
import GEOMap from "../GEOMap";
import { Segment } from "semantic-ui-react";
import { CreatingView, WidgetInfo } from "@generated/graphql";
import { ReactSVG } from "react-svg";
import { parseJSON } from "utils";

import "./style.css";

type GEOMapCellStubProps = WithStoreProps & WidgetProps & {
  defaultPosition?: boolean;
};

export type GEOMapProperties = {
  position: [number, number],
  zoom: number
};

const GEOMapCellStub = ({
  viewId,
  index,
  setCellProps,
  widgetId,
  store: { workspace: { creatingViews } },
  setStore,
  ...props
}: GEOMapCellStubProps) => {
  const widget = Widgets.find(w => w.id === widgetId);

  const findWidget = useCallback((): [CreatingView[] | undefined, WidgetInfo[] | undefined, number | undefined, number | undefined] => {
    if (!creatingViews || index === undefined) {
      return [undefined, undefined, undefined, undefined];
    }

    const views = Array.from(creatingViews);
    const viewIndex = views.findIndex(v => v.viewId + "_selectWidgets" === viewId);
    if (viewIndex < 0 || viewIndex >= views.length) {
      return [undefined, undefined, undefined, undefined];
    }

    const view = views[viewIndex];
    if (!view || !view.widgets || index >= view.widgets.length) {
      return [undefined, undefined, undefined, undefined];
    }

    const widgets = Array.from(view.widgets);
    return [views, widgets, viewIndex, index];
  }, [creatingViews, viewId, index]);

  const setDefaultPositionToStore = useCallback((position: GEOMapProperties) => {
    const [views, widgets, viewIndex, widgetIndex] = findWidget();
    if (!views || !widgets || viewIndex === undefined || widgetIndex === undefined) {
      return;
    }

    const props = parseJSON(widgets[widgetIndex].propsJSON) ?? {};
    props["defaultPositionProperties"] = position;

    widgets[widgetIndex] = { ...widgets[widgetIndex], propsJSON: JSON.stringify(props) };
    views[viewIndex] = { ...views[viewIndex], widgets };
    setStore({ workspace: { creatingViews: views } });
  }, [findWidget]);

  return (
    <>
      {
        !props.defaultPosition ? (
          <Segment className="GEOMapCellStub-Empty">
            {!!widget && <ReactSVG role="icon" src={widget.icon} />}
            <p>{widget?.title}</p>
          </Segment>
        ) : (
          <GEOMap {...props} defaultPosition={props.defaultPosition} setDefaultPositionToStore={setDefaultPositionToStore} />
        )
      }
    </>
  );
};

export default withStore(GEOMapCellStub);
