import React from "react";
import { Header, Table } from "semantic-ui-react";
import { FieldSchema } from "../FieldEditor";
import FieldResolver from "../FieldResolver";

import "./style.css";

type AutoTableProps = {
  schema: FieldSchema;
};

const AutoTable = React.memo(({ schema }: AutoTableProps) => {
  return (
    <>
      {schema.views.map((view, index) =>
        <div className="AutoTable" key={`${view.caption}_${index}`}>
          <Header as="h4">{view.caption ?? ""}</Header>
          <Table compact>
            <Table.Body>
              {view.fields.map((fieldName, index) =>
                !schema.fields[fieldName].hidden &&
                  <Table.Row className={`AutoTable__${fieldName}`} key={`${schema.fields[fieldName]}_${index}`}>
                    <Table.Cell width={index === 0 ? 4 : undefined}>
                      {schema.fields[fieldName]?.label ?? ""}
                    </Table.Cell>
                    <Table.Cell collapsing>
                      {schema.fields[fieldName]?.icon ?? ""}
                    </Table.Cell>
                    <Table.Cell width={index === 0 ? 12 : undefined}>
                      <FieldResolver field={schema.fields[fieldName]} />
                    </Table.Cell>
                  </Table.Row>
              )}
            </Table.Body>
          </Table>
        </div>
      )}
    </>
  );
});

export default AutoTable;
