import React from "react";

import {__} from "@solid/libs/i18n";

import Events, { EventsType }  from "components/Events";
import { WidgetProps } from "components/Widgets";

import "./style.css";

const DeviceEventList = (props: WidgetProps) => {

  return (
    <div className="DeviceEventList">
      <Events
        titleName={__("Devices")}
        eventsType={EventsType.Devices}
        liveOnly={false}
        withFilter
        paginate
        {...props}
      />
    </div>
  );
};

export default DeviceEventList;
