import React from "react";

import Events, { EventsType } from "components/Events";
import { WidgetProps } from "components/Widgets";

import "./style.css";

const ArchiveEvents = (props: WidgetProps) => {
  return (
    <div className="ArchiveEvents">
      <Events
        titleName="Archive"
        eventsType={EventsType.Archive}
        liveOnly={false}
        withFilter
        filterSet={{ cameras: true, sensors: true }}
        paginate
        {...props}
      />
    </div>
  );
};

export default ArchiveEvents;
