import React, { useState } from "react";
import { Button, Icon, Segment } from "semantic-ui-react";
import classNames from "classnames";

import { EventInfo as EventInfoType, WidgetId } from "@generated/graphql";
import { __ } from "@solid/libs";

import { CellProps, Widgets } from "components/Widgets";
import WidgetHeader from "components/WidgetHeader";
import EventList from "components/EventList";
import { EventTypeFilter } from "components/EventList/EventListFilter";
import EventInfo from "components/EventInfo";

import "./style.css";

const acknowledgmentFilter = [EventTypeFilter.NEEDACKNOWLEDGE];

type EventAcknowledgmentProps = {
  onWindowClose: () => void;
};

const EventAcknowledgment = ({ onWindowClose }: EventAcknowledgmentProps) => {
  const [isInfoVisible, setIsInfoVisible] = useState(false);
  const [event, setEvent] = useState<EventInfoType>();
  const [title, setTitle] = useState<React.ReactNode | undefined | null>();

  const EventListWidget = Widgets?.find(w => w.id === WidgetId.EventList);

  function onRowClick(selectedEvent: EventInfoType) {
    if (event?.entry.context === selectedEvent.entry.context) {
      setEvent(undefined);
      return;
    }
    setEvent(selectedEvent);
    setIsInfoVisible(true);
  }

  function setHeader({ title }: CellProps) {
    setTitle(prevTitle => JSON.stringify(prevTitle) === JSON.stringify(title) ? prevTitle : title);
  }

  return (
    <>
      <WidgetHeader icon={EventListWidget?.icon} title={title} onWindowClose={onWindowClose} />
      <Segment className="EventAcknowledgment">
        <div className={classNames("EventAcknowledgment-Main", { isInfoVisible })}>
          <div className="EventAcknowledgment-MainItem">
            <EventList
              liveOnly
              multipleSelect
              eventAcknowledgment
              onRowClick={onRowClick}
              eventTypeFilter={acknowledgmentFilter}
              setCellProps={setHeader}
            />
          </div>
          <div className="EventAcknowledgment-MainItem">
            <div className="EventAcknowledgment-Top">
              <Button
                onClick={() => setIsInfoVisible(false)}
              >
                <Icon name="arrow left"/>
                {__("Back")}
              </Button>
            </div>
            <EventInfo autoUpdate={false} displayAcknowledgeForm event={event} eventAcknowledgment />
          </div>
        </div>
      </Segment>
    </>
  );
};

export default EventAcknowledgment;
