import React from "react";
import { Segment, SemanticWIDTHS, Table } from "semantic-ui-react";

import "./style.css";

export type EntityTableProps = {
  columns?: React.ReactNode[];
  rows?: React.ReactNode[][];
  widths?: (SemanticWIDTHS | undefined)[];
  loading?: boolean;
  emptyLine?: React.ReactNode;
};

const EntityTable = ({ columns, widths, rows, emptyLine, loading }: EntityTableProps) => {
  return (
    <Segment className="EntityTable" loading={loading}>
      <Table celled compact>
        <Table.Header>
          <Table.Row>
            {columns?.map((column, index) =>
              <Table.HeaderCell width={widths?.[index]} key={`${column}_${index}`}>
                {column}
              </Table.HeaderCell>
            )}
          </Table.Row>
        </Table.Header>

        <Table.Body>
          {rows && rows.length > 0 ?
            rows?.map((row, index) =>
              <Table.Row key={`${row}_${index}`}>
                {row.map((item, index) =>
                  <Table.Cell collapsing key={`${item}_${index}`}>
                    {item}
                  </Table.Cell>
                )}
              </Table.Row>
            ) :
            <Table.Row>
              <Table.Cell colSpan={columns?.length} textAlign="center" className="EntityTable-EmptyLine">
                {emptyLine}
              </Table.Cell>
            </Table.Row>}
        </Table.Body>
      </Table>
    </Segment>
  );
};

export default EntityTable;
