import { PlayerMode } from "@solid/types/player_widget";
import { FontAwesomeIcon } from "@fortawesome/react-fontawesome";
import React from "react";

import "./style.css";

type CameraCellHeaderIconProp = {
  mode: PlayerMode
};

const playerModeColors = {
  [PlayerMode.Stopped]: "#FFFFFF",
  [PlayerMode.Archive]: "#DB2828",
  [PlayerMode.Live]: "#21BA45"
};

const CameraCellHeaderIcon = ({ mode }: CameraCellHeaderIconProp) => {
  return <FontAwesomeIcon icon="video" color={playerModeColors[mode]} className="CameraCellHeaderIcon" />;
};

export default CameraCellHeaderIcon;
